#! /usr/bin/env perl
# gen_test_carnet.pl is a test script to produce dummy carnet entries
# and does not strictly need being shipped for day-to-day usage.
use strict;
use warnings;
use POSIX ();

sub print_usage {
	print <<END ;
gen_test_carnet.pl is a script to generate a dummy carnet in the current
working directory.  The first argument is the first year of the writing
into the carnet and the second argument, optional, indicates the end
year of the carnet.

Usage: $0 <start_year> [<end_year>]
END
}

my $max_size_k = 256;

sub write1k {
	my $fh = shift;
	print $fh "12:34 :\n";
	print $fh "#" x 1014;
	print $fh "\n";
}

sub genfilelist {
	my $starting_year = shift;
	my $end_year = shift;

	my @years;
	if (defined $end_year) {
		@years = $starting_year .. $end_year;
	} else {
		@years = ( $starting_year );
	}

	my @files;
	foreach (@years) {
		my $year = $_;
		foreach (1..52) {
			@files = (
				@files,
				sprintf("%04d-%02d.txt", $year, $_)
			);
		}
	}
	return @files;
}

my @files;
if (defined $ARGV[0]) {
	@files = genfilelist($ARGV[0], $ARGV[1]);
} else {
	print_usage;
	exit 1;
}

foreach (@files) {
	open my $fh, ">", $_
		or die "error: opening $_ for writing";
	my $left = $max_size_k;
	while ($left) {
		write1k($fh);
		my $one_more_k = POSIX::ceil(rand(50));
		last if ($one_more_k <= 1);
		$left -= 1;
	}
	close $fh
}
